/*
* STRETCHING/UNSTRETCHING
*/

// functions for stretching/compressing widget to display preview images

Stretcher = {

widget_width : 311, 
min : 69,	// contracted height of widget
max : 229,	// expanded height of widget
amount : 229-69, // max - min

tick : Math.PI/30,
now : Math.PI/2,

anim : null,
face : null,
stretching : false,	// to make sure stretch() isn't called twice

// methods
stretch :
function() {
	if (this.stretching) return 0;
	else this.stretching = true;
	
	if (expanded) { // contracting
		this.anim = setInterval(function() { Stretcher.tickup(); }, 15);	// slow it down a little, so its not too snappy
	}
	else { // stetching
		window.resizeTo(this.widget_width, this.max);
		this.anim = setInterval(function() { Stretcher.tickdn(); }, 0);	// run as fast as possible, since src img is loading simultaneously which slows the thread
	}
},



tickdn : // makes div height larger by 1 'tick'
function() {
	if (this.now <= 0) this.reset();
	else {
		var h = parseInt(this.min + this.amount * Math.cos(this.now));
		this.face.height = h + "px";
		this.now -= this.tick;
	}
},



tickup : // makes div height smaller by 1 'tick'
function() {
	if (this.now >= Math.PI) {
		this.reset();
		window.resizeTo(this.widget_width, this.min);
	}
	else {
		var h = parseInt(this.max + this.amount * Math.cos(this.now));
		this.face.height = h + 'px';
		this.now += this.tick;
	}
},



reset : // once widget is fully stretched
function() {
	this.stretching = false;
	this.now = Math.PI/2;
	clearInterval(this.anim);
	flip_icon_display(expanded); // hide flip icon if widget is expanded
	swap_modes();
}

};

